#!/bin/sh

MASTER_PAGE_NEW_ACCOUNT_NAME_RESULT_MSG=""
MASTER_PAGE_NEW_ACCOUNT_NAME_RESULT_OK=0
MASTER_PAGE_NEW_ACCOUNT_NAME_RESULT_ERROR=1

MASTER_PAGE_NEW_ACCOUNT_NAME_RESULT_CODE=${MASTER_PAGE_NEW_ACCOUNT_NAME_RESULT_ERROR}
MASTER_PAGE_NEW_ACCOUNT_NAME_RESULT_ROLLING=0


master_page_new_account_name() {
    #debug_print "${0}" "${LINENO}" 'in function "master_page_new_esxi_name"'
    
	tp_inputbox \
		"${MASTER_PAGE_NEW_ACCOUNT_NAME_TITLE}" \
		"${MASTER_PAGE_NEW_ACCOUNT_NAME_TEXT}" \
		"${MASTER_PAGE_NEW_ACCOUNT_NAME_OK_LABEL}" \
		"${MASTER_PAGE_NEW_ACCOUNT_NAME_CANCEL_LABEL}"
		
	MASTER_PAGE_NEW_ACCOUNT_NAME_RESULT_CODE=$MASTER_PAGE_NEW_ACCOUNT_NAME_RESULT_OK
	
	if [ "${TP_INPUTBOX_RESULT_CODE}" == "${TP_INPUTBOX_RESULT_CANCEL}" ]; then	
		MASTER_PAGE_NEW_ACCOUNT_NAME_RESULT_ROLLING=-1
		return
	fi
	
    account_to_be_modified=`echo "${TP_INPUTBOX_RESULT_DATA}" | sed -n '1p'`
    dprint "DEBUG" "Add account:${account_to_be_modified}"
    if [ -z "${account_to_be_modified}" ]; then
        warning_with_title "${MASTER_PAGE_NEW_ACCOUNT_NAME_TITLE}" "$MASTER_PAGE_NEW_ACCOUNT_NAME_INVALID_ARGUMENT"
        dprint "ERROR" "$MASTER_PAGE_NEW_ACCOUNT_NAME_INVALID_ARGUMENT"
        MASTER_PAGE_NEW_ACCOUNT_NAME_RESULT_ROLLING=0
        return
    fi

	local ret=`cat /etc/passwd | awk '{FS=":"} {print $1}' | grep "^${account_to_be_modified}$"`
	if [ "${ret}" == "${account_to_be_modified}" ] || [ "${account_to_be_modified}" == "root" ]; then
		local msg=`printf "${MASTER_PAGE_NEW_ACCOUNT_NAME_ALREADY_EXISTS}" "${account_to_be_modified}"`
		warning_with_title "${MASTER_PAGE_NEW_ACCOUNT_NAME_TITLE}" "$msg"
                dprint "ERROR" "$msg"
		MASTER_PAGE_NEW_ACCOUNT_NAME_RESULT_ROLLING=0
        return
	fi
	MASTER_PAGE_NEW_ACCOUNT_NAME_RESULT_ROLLING=1
}
